<?php
$campaign_address = isset($_GET['c8']) ? $_GET['c8'] : '';

$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";

$landingsPath = $_SERVER['DOCUMENT_ROOT'] . '/promotions/ll/landings/';

if (in_array(substr($campaign_address, 0, 5), ['fr_BE', 'nl_BE'])) {
    $landingPath = substr($campaign_address, 6);
    $geo = substr($campaign_address, 0, 5);
} else {
    $landingPath = $campaign_address;
}

$folder = $landingsPath . $landingPath;

$settingsFilePath = $folder . DIRECTORY_SEPARATOR . 'settings.json';

$name = isset($_GET['c2']) ? ' ' . $_GET['c2'] : '';
$sub4 = isset($_GET['c2']) ? $_GET['c2'] : '';

$defaultTitle = 'an iPhone 12';
$defaultImage = $protocol .substr($_SERVER['PHP_SELF'], 0, strrpos($_SERVER['PHP_SELF'], '/')) . 'images/product.png';

if (file_exists($settingsFilePath)) {
    $settings = json_decode(file_get_contents($settingsFilePath), true);

    if (false === isset($geo)) {
        switch ($settings['country']) {
            case 'DE':
                $geo = 'de_DE';
                break;
            case 'ES':
                $geo = 'es_ES';
                break;
            case 'FR':
                $geo = 'fr_FR';
                break;
            case 'ID':
                $geo = 'id_ID';
                break;
            case 'IT':
                $geo = 'it_IT';
                break;
            case 'NL':
                $geo = 'nl_NL';
                break;
            case 'TH':
                $geo = 'th_TH';
                break;
            case 'UK':
                $geo = 'en_UK';
                break;
            default:
                $geo = 'en_UK';
        }
    }

    if (isset($settings['settings']['exit_title']) && isset($settings['settings']['exit_title'][$geo])) {
        $title = $settings['settings']['exit_title'][$geo];
    }
    if (isset($settings['settings']['product_image'])) {
        $imageName = $protocol . '/promotions/ll/end/uk/f-exit-deskwall-valid/images/' . $landingPath . '/' . $settings['settings']['product_image'];
    }

} else {
    $title = $defaultTitle;
    $imageName = $defaultImage;
}

switch ($campaign_address) {

    default:
        $title = 'an iPhone 12';
        $imageName = 'product.png';
        break;
        
}

$deals_splitted = [
    'silver' => [
        
        [
            'image' => 'Product-3.png',
            'title' => 'RYOKU EMS Foot Massager',
            'description' => 'Relax and rejuvenate with the Ryoku EMS Foot Massager! Stimulates muscles and relieves foot fatigue with EMS technology. Compact, lightweight, and easy to use anywhere.',
            'prize' => '',
            'link' => 'https://www.trk2dkt.com/2KGQG8/9GG2SS/?uid=6135&sub4=' . rawurlencode($sub4)
        ],
        [
            'image' => 'pestpulse.png',
            'title' => 'PestPulse',
            'description' => 'New guardian against pests. Say Goodbye to Pests, Hello to Peace!',
            'prize' => '',
            'link' => 'https://www.trk2dkt.com/2KGQG8/9GG2SS/?uid=6136&sub4=' . rawurlencode($sub4)
        ],
        [
            'image' => 'heater.png',
            'title' => 'Pro Capture',
            'description' => 'Capture life\'s epic moments. Whether you are hiking mountains, diving into oceans, or just living boldly, Pro Capture lets you relive it all in stunning 4K. Waterproof, shockproof, and ultra-stable - this action cam is your ultimate adventure companion.',
            'prize' => '',
            'link' => 'https://www.trk2dkt.com/2KGQG8/9GG2SS/?uid=6127&sub4=' . rawurlencode($sub4)
        ],
        [
            'image' => 'Earthingsheet.jpg',
            'title' => 'AirRush',
            'description' => 'Your personal breeze, anytime. Stay cool wherever you go with AirRush - a powerful yet whisper-quiet portable fan that fits in your hand but packs a punch. Rechargeable, sleek, and summer-ready.',
            'prize' => '',
            'link' => 'https://www.trk2dkt.com/2KGQG8/9GG2SS/?uid=6137&sub4=' . rawurlencode($sub4)
        ],
        [
            'image' => 'Product-2.png',
            'title' => 'UltraV Bottle',
            'description' => 'Clean water, anywhere. UltraV Bottle purifies your water in just 60 seconds using advanced UV-C tech. Safe, sleek, and eco-friendly - it\'s your new travel essential.',
            'prize' => '',
            'link' => 'https://www.trk2dkt.com/2KGQG8/9GG2SS/?uid=6130&sub4=' . rawurlencode($sub4)
        ],
        [
            'image' => 'daylight.jpg',
            'title' => 'OxiPulse Pro',
            'description' => 'Breathe easy with confidence. Track your oxygen levels and heart rate in seconds with OxiPulse Pro. Perfect for athletes, seniors, and wellness lovers. Lightweight, accurate, and USB-rechargeable.',
            'prize' => '',
            'link' => 'https://www.trk2dkt.com/2KGQG8/9GG2SS/?uid=6139&sub4=' . rawurlencode($sub4)
        ],

        
    ],
    'gold' => [
    ],
    'platinum' => [
    ]
];
