$(document).ready(function() {
    // Deals done
    $(document).on('click', '#deals-done', dealsDone)
    $(document).on('click', '.popup-deals ._back', dealsBack)
    $(document).on('click', '.popup-deals ._continue', dealsContinue)
    $(document).on('click', '.popup-congrats button', dealsCongrats)
    $(document).on('click', '.deal', finishDeal)

    function pad(n, width, z) {
        z = z || '0';
        n = n + '';
        return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
    }

    function dealsDone() {

        if (typeof sendGoogleTrackEvent === 'function') {
            switch (current_deals) {
                case 'silver':
                    sendGoogleTrackEvent('03. silver button', pad(done_deals[current_deals]['done'], 2));
                    break;
                case 'gold':
                    sendGoogleTrackEvent('05. gold button', pad(done_deals[current_deals]['done'], 2));
                    break;
                case 'platinum':
                    sendGoogleTrackEvent('07. platinum button', pad(done_deals[current_deals]['done'], 2));
                    break;
            }
        }

        if (done_deals[current_deals]['done'] >= done_deals[current_deals]['minimum']) {
            window.scrollTo(0, 0);
            if (current_deals === 'silver') {
                // Go to gold tier and autocomplete 1 offer
                $('._deals-text').text('The final stage!');
                setTimeout(function () {
                    $('.popups').addClass('show-popup popup-congrats');
                    done_deals[current_deals]['done']++;

                    $('._deals_left').text(done_deals[current_deals]['minimum'] - done_deals[current_deals]['done']);
                }, 1200);
                current_deals = 'gold';
                $('.deals-group.deals-silver').hide();
                $('.deals-group.deals-gold').addClass('d-flex');
                // sendGoogleTrackEvent('10. Silver Deal Next', 'Continue');
            } else if (current_deals === 'gold') {
                // Go to platinum
                current_deals = 'platinum';
                $('.deals-group').addClass('deals-platinum');
                $('.deals-group').addClass('d-flex');
                $('.deals-extra-header').addClass('d-none');
                $('.deals-final-header').removeClass('d-none');
                $('#deals-done').remove();
                // sendGoogleTrackEvent('13. Golds Deal Next', 'Continue');
            }

            $('._deals_left').text(done_deals[current_deals]['minimum'] - done_deals[current_deals]['done']);

            // for (var x = 0; x < deals_clicked.length; x++) {
            //     console.log('[data-deal="' + deals_clicked[x] + '"]');
            //     console.log($('[data-deal="' + deals_clicked[x] + '"]'));
            //     $('[data-deal="' + deals_clicked[x] + '"]').parent().remove();
            // }
        } else {
            window.scrollTo(0, 0);
            $('._deals_left').text(done_deals[current_deals]['minimum'] - done_deals[current_deals]['done']);
            $('.popups').addClass('show-popup popup-deals');

            if (current_deals == 'silver') {
                // sendGoogleTrackEvent('10. Silver Deal Next', 'Popup');
            } else if (current_deals == 'gold') {
                // sendGoogleTrackEvent('13. Golds Deal Next', 'Popup');
            }
        }
    }


    var current_perc = 60;
    function progressAdd(perc) {
        current_perc = Math.floor(current_perc + perc);

        $('.progressbar .progress-inner').css('width', current_perc+'%');
        $('._perc').text(current_perc+'%');
    }

    function dealsCongrats() {
        $('.popups').removeClass('show-popup popup-congrats');
        progressAdd(deal_perc);
    }

    function dealsBack() {
        $('.popups').removeClass('show-popup popup-deals');

        if (current_deals == 'silver') {
            // sendGoogleTrackEvent('11. Silver Deal Alert', 'Go Back');
        } else if (current_deals == 'gold') {
            // sendGoogleTrackEvent('14. Gold Deals Alert', 'Go Back');
        }
    }

    function dealsContinue() {
        $('.popups').removeClass('show-popup popup-deals');
    }

    var current_deals = 'silver';
    var done_deals = {
        'silver': {
            'done': 0,
            'minimum': 1,
        },
        'gold': {
            'done': 0,
            'minimum': 2,
        },
        'platinum': {
            'done': 0,
            'minimum': 8,
        },
    };
    var deals_clicked = [];

    var deal_perc = 40 / (done_deals['silver']['minimum'] + done_deals['gold']['minimum'] + done_deals['platinum']['minimum']);
    console.log(deal_perc);
    function finishDeal() {
        "use strict";

        var deal_id = $(this).attr('data-deal');

        if ($.inArray(deal_id, deals_clicked) === -1) {
            done_deals[current_deals]['done']++;
            console.log(done_deals, deals_clicked);
            deals_clicked.push(deal_id);
            console.log('deals_clicked:');
            console.log(deals_clicked);

            if (typeof sendGoogleTrackEvent === 'function') {
                switch (current_deals) {
                    case 'silver':
                        sendGoogleTrackEvent('02. silver deal clicked');
                        break;
                    case 'gold':
                        sendGoogleTrackEvent('04. gold deal clicked');
                        break;
                    case 'platinum':
                        sendGoogleTrackEvent('06. platinum deal clicked');
                        break;
                }
            }

            if (current_deals == 'silver'){
                if (done_deals[current_deals]['done'] == 1) {
                    progressAdd(deal_perc);
                }
            } else {
                if (done_deals[current_deals]['done'] <= done_deals[current_deals]['minimum']) {
                    progressAdd(deal_perc);
                }
            }
        }
    }
})