<?php
include('config.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title></title>
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800,900&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,600,700,800,900&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <link rel="stylesheet" href="css/wall.css">

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-124267345-1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'UA-124267345-1');

        var eventCategory = '<?=(isset($_GET['c8']) ? $_GET['c8'] : 'none');?>';

        window.sendGoogleTrackEvent = function(action, label, labelValue, category) {
            if (typeof action === 'undefined'){
                // We do nothing because there's nothing to send
            } else {
                if (typeof category === 'undefined')
                    category = eventCategory;

                if (typeof labelValue === 'undefined')
                    labelValue = 'NONE';

                if (typeof label === 'undefined')
                    label = 'NONE';

                gtag('event', action, {
                    'event_category': category,
                    'event_label': label,
                    'value': labelValue
                });
            }
        }

        window.sendGoogleTrackEvent('01. home');
    </script>

    <!-- Hotjar Tracking Code for https://getyourmonthlychance.com/ -->
    <script>
        (function(h,o,t,j,a,r){
            h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
            h._hjSettings={hjid:2284851,hjsv:6};
            a=o.getElementsByTagName('head')[0];
            r=o.createElement('script');r.async=1;
            r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
            a.appendChild(r);
        })(window,document,'https://static.hotjar.com/c/hotjar-','.js?sv=');
    </script>

    <!-- Webpush script-->
    <script src="https://virtualpushplatform.com/ace-push.js"></script>
    <script> initializeAcePush('df62ef64-814c-4ef4-b5e0-f65485c0d8c9');</script>

</head>
<body>
<div id="app">
    <section id="survey" class="">
        <header>
            <div class="container">
                <img class="lock-icon" src="images/checked-hf.svg">
                <div class="pill"></div>
                <div class="pill pill-lg pill-green">
                    Thank You!
                </div>
                <div class="pill pill-green"></div>
                <div class="product-image-wrapper">
                    <img src="images/<?=$imageName;?>">
                </div>
            </div>
        </header>

        <div class="container title">
            <div class="row">
                <div class="col-12">
                    <br>
                    <h3>
                        Thank you for your purchase! <br><br>

                        As a valued customer, we’re excited to offer you an exclusive UP TO  70% discount on our top-rated products below. 
                        <br><br>
                        Don’t miss out on this limited-time deal, just for you!
                    </h3>
                </div>
            </div>
        </div>

        <div class="container px-0" id="deals">
            <?php foreach ($deals_splitted as $deal_key => $deal_group) { ?>
                <div class="row no-gutters deals-group deals-<?=$deal_key;?>">
                <?php foreach ($deal_group as $index => $deal) { ?>
                    <div class="col-12 col-md-6 d-flex align-items-stretch">
                        <a target="_blank" data-deal="<?=$deal_key;?>-<?=$index;?>" href="<?=$deal['link'];?>" class="d-flex flex-column justify-content-between deal">
                            <div class="row no-gutters">
                                <div class="col-12">
                                    <div class="price text-right"><?=$deal['prize'];?></div>
                                </div>
                                <div class="col-4">
                                    <img src="images/deals/<?=$deal['image'];?>" class="deal-image">
                                </div>
                                <div class="col-8 col-text">
                                    <h1><?=$deal['title'];?></h1>
                                    <p><?=$deal['description'];?></p>
                                </div>
                            </div>
                            <div class="row footer-row">
                                <div class="col-4 col-stars">
                                    <img class="star silver-star" src="images/silver.svg">
                                    <img class="star gold-star" src="images/gold.svg">
                                    <img class="star platinum-star" src="images/platinum.svg">
                                </div>
                                <div class="col-8 col-btn">
                                    <button class="get-deal">UP TO  70%</button>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php } ?>
            </div>
            <?php } ?>
        </div>

        <div class="container submit-holder">
            <div class="row">
                <div class="col-12">
                </div>
            </div>
        </div>
    </section>
    <div class="popups">
        <div class="popup-fade d-none"></div>
        <div class="popup popup-survey d-none"><img src="images/popup-survey.gif"
                                                    class="popup-image">
            <div class="loader">
                <div class="loader-inner" style="width: 100%;"></div>
            </div>
            <h1>
                Checking requirements...
            </h1>
            <div class="loader-steps">
                <div data-step="1" class="loader-step"><span class="icon"></span>
                    Complete survey
                </div>
                <br>
                <div data-step="2" class="loader-step"><span class="icon"></span>
                    View offers
                </div>
                <br>
                <div data-step="3" class="loader-step"><span class="icon"></span>
                    Claim deals
                </div>
                <br>
                <div data-step="4" class="loader-step"><span class="icon"></span>
                    One last step
                </div>
            </div>
        </div>
        <div class="popup popup-congrats d-none">
            <h1 class="text-red">
                Thank you!
            </h1>
            <p>
                A deal has just been completed for you! You will continue to the <b>gold stage</b> now
            </p>
            <p class="text-red">
                Complete <strong class="_deals_left">1</strong> more deal to<br>continue towards <?=$title;?>!
            </p>
            <div>
                <button>
                    Continue
                </button>
            </div>
        </div>
        <div class="popup popup-deals d-none"><h1>
                Alert!
            </h1>
            <p>
                You must complete <span class="_deals_left">1</span> deal to claim your chance
            </p>
            <div>
                <button class="_back">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="15" viewBox="0 0 20 15" fill="none">
                        <path d="M0.898074 6.84835C0.50755 7.23887 0.50755 7.87203 0.898074 8.26256L7.26204 14.6265C7.65256 15.017 8.28573 15.017 8.67625 14.6265C9.06677 14.236 9.06677 13.6028 8.67625 13.2123L3.01939 7.55545L8.67625 1.8986C9.06677 1.50807 9.06677 0.874908 8.67625 0.484383C8.28572 0.0938592 7.65256 0.0938592 7.26203 0.484384L0.898074 6.84835ZM19.3129 6.55545L1.60518 6.55545L1.60518 8.55545L19.3129 8.55545L19.3129 6.55545Z" fill="white"/>
                    </svg>
                    Go back
                </button>
            </div>

        </div>
        <div class="popup popup-after-form d-none"><img src="images/popup-form.gif"
                                                        class="popup-image">
            <div class="loader">
                <div class="loader-inner" style="width: 100%;"></div>
            </div>
            <h1>
                Awesome
            </h1>
            <p><span class="_firstname">Flapsie</span>, Now just take our survey and follow instructions
            </p>
            <h3>
                It's that easy!
            </h3></div>
    </div>
    <div class="footer">
        <div class="container">
            <div class="footer__nav">
                
            </div>
        </div>
    </div>
    <div id="modal-terms-and-conditions" tabindex="-1" role="dialog" aria-labelledby="modal-terms-and-conditions"
         class="modal">
        <div class="container">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span
                                aria-hidden="true">×</span></button>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script src="js/wall.js"></script>
</body>
</html>
